/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tomcat;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.connmgr.ConnectionFactory;
import com.ibm.hwmca.fw.servlet.helptools.HelpSupport;
import com.ibm.hwmca.fw.shutdown.ShutdownDialog;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.system.IniFileProcessor;
import com.ibm.hwmca.fw.tasklet.Client;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.tomcat.HmcFormAuthenticator;
import com.ibm.hwmca.fw.tomcat.HmcLogger;
import com.ibm.hwmca.fw.tomcat.HmcRealm;
import com.ibm.hwmca.fw.tomcat.HmcRequestDumper;
import com.ibm.hwmca.fw.tomcat.HmcSessionManager;
import com.ibm.hwmca.fw.ui.UIStyle;
import com.ibm.hwmca.fw.ui.UIStyleManager;
import com.ibm.hwmca.fw.util.CommonResourceBundle;
import com.ibm.hwmca.fw.util.HThreadGroup;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.naming.directory.DirContext;
import org.apache.ajp.tomcat4.Ajp13Connector;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.startup.Embedded;
import org.apache.coyote.tomcat4.CoyoteConnector;
import org.apache.naming.resources.FileDirContext;

public class Startup
implements Runnable {
    private static final String START_INI_FILE_NAME = "clientstart.ini";
    private static final String TRACE_MASKT = "XTOMSTRT";
    private static final String TRACE_MASKF = "XTOMSTRF";
    private static final String TRACE_MASKD = "XTOMSTRD";
    private static int debugLevel = 4;

    public Startup() {
        Trace.trace(TRACE_MASKF, "Startup.ctor()");
    }

    public void run() {
        Trace.trace(TRACE_MASKT, "-> Startup.run()");
        try {
            Ajp13Connector connector;
            CommonSystem commonSystem = CommonSystem.getCommonSystem();
            if (!commonSystem.isLocationUnified()) {
                commonSystem.setLocation(2);
            }
            commonSystem.setManagerHost("127.0.0.1");
            commonSystem.setClientOnServerMachine(true);
            commonSystem.setUsingHTML(true);
            String catalinaHome = System.getProperty("catalina.home");
            if (catalinaHome == null) {
                Trace.trace(TRACE_MASKF, "'catalina.home' system property not set");
                throw new IllegalStateException("'catalina.home' system property not set");
            }
            HmcRealm realm = new HmcRealm();
            realm.setDebug(debugLevel);
            Embedded embedded = new Embedded((Logger)new HmcLogger(), (Realm)realm);
            embedded.setDebug(debugLevel);
            Engine engine = embedded.createEngine();
            engine.setName("HmcEngine");
            engine.setDefaultHost("127.0.0.1");
            HmcLogger logger = new HmcLogger();
            logger.setMask("XTOMLGE");
            logger.setVerbosity(4);
            engine.setLogger((Logger)logger);
            HmcRequestDumper dumper = new HmcRequestDumper();
            ((StandardEngine)engine).addValve((Valve)dumper);
            StandardHost host = (StandardHost)embedded.createHost("127.0.0.1", catalinaHome + "/webapps");
            logger = new HmcLogger();
            logger.setMask("XTOMLGH");
            logger.setVerbosity(4);
            host.setLogger((Logger)logger);
            host.setUnpackWARs(true);
            host.setErrorReportValveClass("com.ibm.hwmca.fw.tomcat.HmcErrorReportValve");
            host.setParent((Container)engine);
            engine.addChild((Container)host);
            Context root = embedded.createContext("", catalinaHome + "/../www");
            logger = new HmcLogger();
            logger.setMask("XTOMLGC");
            logger.setVerbosity(4);
            root.setLogger((Logger)logger);
            root.setParent((Container)host);
            FileDirContext fdc = new FileDirContext();
            fdc.setDocBase(root.getDocBase());
            fdc.setAllowLinking(true);
            root.setResources((DirContext)fdc);
            host.addChild((Container)root);
            Context context = embedded.createContext("/hmc", catalinaHome + "/webapps/hmc");
            context.setRealm((Realm)realm);
            HmcSessionManager mgr = new HmcSessionManager();
            mgr.setDebug(debugLevel);
            context.setManager((Manager)mgr);
            context.setLogger((Logger)logger);
            context.setSessionTimeout(4320);
            HmcFormAuthenticator formAuth = new HmcFormAuthenticator();
            formAuth.setDisableProxyCaching(false);
            ((StandardContext)context).addValve((Valve)formAuth);
            context.setParent((Container)host);
            host.addChild((Container)context);
            Context monitorContext = embedded.createContext("/preloginmonitor", catalinaHome + "/webapps/preloginmonitor");
            HmcSessionManager monitorMgr = new HmcSessionManager();
            monitorMgr.setDebug(debugLevel);
            monitorContext.setManager((Manager)monitorMgr);
            monitorContext.setLogger((Logger)logger);
            monitorContext.setSessionTimeout(4320);
            monitorContext.setParent((Container)host);
            host.addChild((Container)monitorContext);
            StandardWrapper wrapper = null;
            Iterator styleIt = UIStyleManager.getUIStyleManager().getUIStyles().iterator();
            while (styleIt.hasNext()) {
                UIStyle style = (UIStyle)styleIt.next();
                Iterator servletIt = style.getServletNames().iterator();
                while (servletIt.hasNext()) {
                    String name = (String)servletIt.next();
                    String uri = style.getServletURI(name);
                    String className = style.getServletClassName(name);
                    Trace.trace(TRACE_MASKF, "adding servlet mapping: name=[" + name + "]; class=[" + className + "]; uri=[" + uri + "].");
                    wrapper = new StandardWrapper();
                    wrapper.setServletName(name);
                    wrapper.setServletClass(className);
                    wrapper.setParent((Container)context);
                    context.addChild((Container)wrapper);
                    context.addServletMapping(uri, name);
                }
            }
            Context helpContext = embedded.createContext("/help", catalinaHome + "/webapps/help");
            helpContext.setRealm((Realm)realm);
            HmcSessionManager helpMgr = new HmcSessionManager();
            helpMgr.setDebug(debugLevel);
            helpContext.setManager((Manager)helpMgr);
            helpContext.setLogger((Logger)logger);
            helpContext.setSessionTimeout(4320);
            FormAuthenticator helpFormAuth = new FormAuthenticator();
            helpFormAuth.setDisableProxyCaching(false);
            ((StandardContext)context).addValve((Valve)helpFormAuth);
            helpContext.setParent((Container)host);
            host.addChild((Container)helpContext);
            embedded.addEngine(engine);
            if (System.getProperty("USING_APACHE", "false").equals("true")) {
                connector = new Ajp13Connector();
                connector.setDebug(debugLevel);
                connector.setAddress("localhost");
                connector.setPort(8009);
                connector.setMinProcessors(5);
                connector.setMaxProcessors(15);
                connector.setAcceptCount(10);
                embedded.addConnector((Connector)connector);
            } else {
                connector = new CoyoteConnector();
                connector.setDebug(debugLevel);
                connector.setPort(8080);
                connector.setMinProcessors(5);
                connector.setMaxProcessors(75);
                connector.setSecure(false);
                connector.setEnableLookups(true);
                connector.setAcceptCount(10);
                connector.setConnectionTimeout(20000);
                connector.setRedirectPort(8443);
                embedded.addConnector((Connector)connector);
            }
            HelpSupport.prepareHelpWebapp();
            ClientUserContext cuc = new ClientUserContext(new ConnectionFactory(commonSystem.getManagerHost(), 9940));
            cuc.attachToThread(true);
            IniFileProcessor.runClasses(START_INI_FILE_NAME, "Client INI");
            embedded.start();
            Trace.trace(TRACE_MASKF, "Started embedded tomcat");
            try {
                ShutdownDialog.destroy();
            }
            catch (Exception e) {
                // empty catch block
            }
            BrowserRespawnThread browserThread = null;
            boolean startBrowser = System.getProperty("START_BROWSER", "true").equals("true");
            if (startBrowser) {
                browserThread = new BrowserRespawnThread();
                browserThread.start();
            }
            Client startupClient = new Client("com.ibm.hwmca.fw.system.KeepAliveTasklet", null);
            TaskletResponse response = startupClient.init();
            Trace.trace(TRACE_MASKF, "Startup.run: Tasklet responded.. shutting down");
            if (browserThread != null) {
                Trace.trace(TRACE_MASKF, "Startup.run: killing browser");
                browserThread.stopBrowser();
            }
            Integer rc = (Integer)response.getData("RC");
            Trace.trace(TRACE_MASKF, "Startup.run: Exiting with value " + rc);
            String desktopFileName = BaseFileControl.getFilePath("actzdesk.dat") + "actzdesk.dat";
            File desktopFile = new File(desktopFileName);
            if (desktopFile.exists()) {
                LocalizableText text = null;
                switch (rc) {
                    case 100: {
                        text = new LocalizableText(CommonResourceBundle.getBundleName(), "shutdown.restart");
                        break;
                    }
                    case 102: {
                        text = new LocalizableText(CommonResourceBundle.getBundleName(), "shutdown.shutdown");
                        break;
                    }
                    case 103: {
                        text = new LocalizableText(CommonResourceBundle.getBundleName(), "shutdown.poweroff");
                        break;
                    }
                    default: {
                        text = new LocalizableText(CommonResourceBundle.getBundleName(), "shutdown.reboot");
                    }
                }
                String[] cmd = text != null ? new String[5] : new String[]{"java", "-classpath", System.getProperty("java.class.path"), "com.ibm.hwmca.fw.shutdown.ShutdownDialog"};
                if (text != null) {
                    cmd[4] = text.toString();
                }
                Runtime.getRuntime().exec(cmd);
                try {
                    Thread.currentThread();
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            System.exit(rc);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception starting Tomcat...");
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKT, "<- Startup.run()");
    }

    public static void main(String[] args) {
        try {
            Trace.trace(TRACE_MASKF, "Starting the Tomcat server");
            Startup starter = new Startup();
            HThreadGroup.defaultThreadGroup().createThread(starter, "TomcatMain").start();
        }
        catch (Throwable thrown) {
            Trace.trace(TRACE_MASKF, "Exception starting Tomcat thread");
            Trace.trace(TRACE_MASKF, thrown);
        }
    }

    class BrowserRespawnThread
    extends Thread {
        Process browserProcess;
        boolean stopped = false;
        boolean browserRunning = true;

        BrowserRespawnThread() {
            super("Local browser process spawner");
        }

        public void run() {
            String geom;
            Dimension screen;
            String mozillaCmd;
            File operaFile;
            block16: {
                Trace.trace(Startup.TRACE_MASKT, "-> BrowserRespawnThread.run");
                Trace.trace(Startup.TRACE_MASKF, "BrowserRespawnThread: starting browser for the first time.. pointing at preLogon servlet");
                this.removeLockFile();
                String operaFilename = System.getProperty("CONSOLE_PATH") + "use_opera";
                operaFile = new File(operaFilename);
                mozillaCmd = System.getProperty("DEVELOPMENT_SYSTEM", "no").equalsIgnoreCase("yes") ? (operaFile.exists() ? "opera -nosession -newwindow -windowname main" : "mozilla") : (operaFile.exists() ? "opera -nomenu -nocontextmenu -nosplash -nosession -newwindow -windowname main" : "mozilla -P default");
                boolean usingSSL = System.getProperty("USING_APACHE_SSL", "false").equalsIgnoreCase("true");
                try {
                    if (operaFile.exists()) {
                        screen = Toolkit.getDefaultToolkit().getScreenSize();
                        geom = " -geometry 750x600+" + (screen.width - 750) / 2 + "+" + (screen.height - 600) / 2;
                        this.browserProcess = Runtime.getRuntime().exec(mozillaCmd + geom);
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        Runtime.getRuntime().exec("opera -nosession -windowname main -remote openURL(http://127.0.0.1:8080/prelogon.html)");
                        break block16;
                    }
                    this.browserProcess = Runtime.getRuntime().exec(mozillaCmd + " http://127.0.0.1:8080/prelogon.html");
                }
                catch (IOException e) {
                    Trace.trace(Startup.TRACE_MASKF, "BrowserRespawnThread: failed to start browser.");
                    Trace.trace(Startup.TRACE_MASKF, e);
                    return;
                }
            }
            while (true) {
                this.browserRunning = true;
                while (this.browserRunning) {
                    try {
                        this.browserProcess.waitFor();
                        Trace.trace(Startup.TRACE_MASKF, "BrowserRespawnThread: browser returned.");
                        this.browserRunning = false;
                    }
                    catch (InterruptedException e) {}
                }
                if (this.stopped) break;
                Trace.trace(Startup.TRACE_MASKF, "BrowserRespawnThread: respawning browser.");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.removeLockFile();
                try {
                    if (operaFile.exists()) {
                        screen = Toolkit.getDefaultToolkit().getScreenSize();
                        geom = " -geometry 750x600+" + (screen.width - 750) / 2 + "+" + (screen.height - 600) / 2;
                        this.browserProcess = Runtime.getRuntime().exec(mozillaCmd + geom);
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        Runtime.getRuntime().exec("opera -nosession -windowname main -remote openURL(http://127.0.0.1:8080/localindex.html)");
                        continue;
                    }
                    this.browserProcess = Runtime.getRuntime().exec(mozillaCmd + " http://127.0.0.1:8080/localindex.html");
                }
                catch (IOException e) {
                    Trace.trace(Startup.TRACE_MASKF, "BrowserRespawnThread: failed to start browser");
                    Trace.trace(Startup.TRACE_MASKF, e);
                    return;
                }
            }
            Trace.trace(Startup.TRACE_MASKF, "<- BrowserRespawnThread.run");
        }

        private void removeLockFile() {
            Trace.trace(Startup.TRACE_MASKT, "-> BrowserRespawnThread.removeLockFile()");
            try {
                String script = BaseFileControl.getFilePath("runAsRoot") + "removeMozillaLockFile.sh";
                Process p = Runtime.getRuntime().exec(script);
                int rc = 0;
                boolean done = false;
                while (!done) {
                    try {
                        rc = p.waitFor();
                        done = true;
                    }
                    catch (InterruptedException e) {}
                }
                Trace.trace(Startup.TRACE_MASKF, "BrowserRespawnThread.removeLockFile: script returned " + rc);
            }
            catch (HException e) {
                Trace.trace(Startup.TRACE_MASKF, e);
            }
            catch (IOException e) {
                Trace.trace(Startup.TRACE_MASKF, e);
            }
            Trace.trace(Startup.TRACE_MASKT, "<- BrowserRespawnThread.removeLockFile()");
        }

        void stopBrowser() {
            Trace.trace(Startup.TRACE_MASKF, "<> BrowserRespawnThread.stopBrowser()");
            this.stopped = true;
            this.browserProcess.destroy();
            try {
                Runtime.getRuntime().exec("killall -15 mozilla-bin");
            }
            catch (IOException e) {
                Trace.trace(Startup.TRACE_MASKF, "BrowserRespansThread.stopBrowser: failed to kill mozilla-bin");
                Trace.trace(Startup.TRACE_MASKF, e);
            }
        }
    }
}

